
  import javafx.application.Application;
  import javafx.collections.*;
  import javafx.geometry.*;
  import javafx.scene.control.*;
  import javafx.scene.layout.*;
  import javafx.scene.text.Font;
  import javafx.scene.Scene;
  import javafx.stage.Stage;

  public class MealMenu2 extends Application 
  {
     ComboBox entrees;
     ListView extras;
     Button placeOrder;
    
     @Override
     public void start(Stage primaryStage) 
     {
        GridPane root = new GridPane();
        root.setPadding(new Insets(10));
        root.setHgap(5);
        
	  //Declare the ComboBox's label, its items, the ComboBox and VBox 
        Label entreesLbl = new Label("Entrees");
        entreesLbl.setFont(new Font("Arial", 14));
        ObservableList entreeItems = FXCollections.observableArrayList(
                                     "a Taco", "a BLT Sandwich", "Nachos",
                                     "a Hambuger", "Chicken Soup",
                                     "Hot Chili", "a Salad");
        entrees = new ComboBox(entreeItems);
        entrees.setPromptText("Make a Selection");
        VBox comboPane = new VBox(entreesLbl, entrees);
        comboPane.setPrefWidth(180);
        comboPane.setPrefHeight(180);
        comboPane.setSpacing(7);
        comboPane.setPadding(new Insets(5));

        //Declare the ListView's label, its items, the ListView and VBox
        Label extrasLbl = new Label("Extras");
        extrasLbl.setFont(new Font("Arial", 14));
        extras = new ListView();
        ObservableList<String> extrasList = extras.getItems(); 
        extrasList.addAll("Cheese", "Ketchup", "Napkins", "Mustard", 
                          "Mayonnaise", "Salsa", "a Paper Plate", 
        extras.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        VBox listPane = new VBox(extrasLbl, extras);
        listPane.setPrefWidth(180);
        listPane.setSpacing(7);
        listPane.setPadding(new Insets(5));        

        //Declare the Place Order button and register its event handler
        placeOrder = new Button("Place Order");
        placeOrder.setOnAction(e -> placeOrderHandler());
        
        root.addRow(0, comboPane, listPane);
        root.setHalignment(placeOrder, HPos.CENTER);
        root.add(placeOrder, 0, 1, 2, 1);

        Scene scene = new Scene(root, 360, 200);
        
        primaryStage.setTitle("Dollar Meal");
        primaryStage.setScene(scene);
        primaryStage.show();
     }
      
     public void placeOrderHandler()
     {
        String order = "Your order is " + entrees.getValue();
        ObservableList<String> extrasSelected;
        extrasSelected = extras.getSelectionModel().getSelectedItems();
        for(String extra : extrasSelected)
        {
           order = order + ", and " + extra;
        }
        System.out.println(order);
     }

     public static void main(String[] args) 
     {
        launch(args);
     }
  }
   
